<?php
/**
 * Plugin Name: ShopiMind
 * Description: Connecteur ShopiMind pour WooCommerce
 * Version: 1.7.1
 * Plugin Slug: shopimind
 * Author: ShopiMind
 * Author URI: https://www.shopimind.com/
 * Text Domain: shopimind
 * Domain Path: /languages
 * WC requires at least: 3.0.0
 * WC tested up to: 9.3.3
 */


defined( 'SHOPIMIND_DIR' ) 		or define( 'SHOPIMIND_DIR', 	dirname( __FILE__ ) ); // our directory.
defined( 'SHOPIMIND_PATH' ) 	or define( 'SHOPIMIND_PATH', 	realpath( __DIR__ ) ); // our directory.
defined( 'SHOPIMIND_URL' ) 		or define( 'SHOPIMIND_URL', 	plugins_url( '', __FILE__ ) );

defined( 'SHOPIMIND_VERSION' )	or define( 'SHOPIMIND_VERSION',	'3.1.1' );
$plugin_data = get_file_data( __FILE__, array( 'Version' => 'Version' ), false );
defined( 'SHOPIMIND_PLUGIN_VERSION' )	or define( 'SHOPIMIND_PLUGIN_VERSION',	$plugin_data['Version'] );

$wp_upload_dir = wp_upload_dir();
defined( 'SHOPIMIND_FILES' )		or define( 'SHOPIMIND_FILES', 		$wp_upload_dir['basedir'] . '/shopimind' );
defined( 'SHOPIMIND_FILES_URL' )	or define( 'SHOPIMIND_FILES_URL', 	$wp_upload_dir['baseurl'] . '/shopimind' );
if( !is_dir( SHOPIMIND_FILES )) 	mkdir( SHOPIMIND_FILES );

defined( 'SHOPIMIND_SELF_API_URL' ) or define( 'SHOPIMIND_SELF_API_URL', trailingslashit( SHOPIMIND_URL ) . 'api/call.php' );

try {
    require_once( trailingslashit( SHOPIMIND_PATH ) . 'includes/shopimind-constants.php' );
    require_once( trailingslashit( SHOPIMIND_PATH ) . 'shopimind-configuration.class.php' );
    require_once( trailingslashit( SHOPIMIND_PATH ) . 'includes/shopimind-functions.php' );
    require_once( trailingslashit( SHOPIMIND_PATH ) . 'includes/shopimind-async-hooks.php' );
    require_once( trailingslashit( SHOPIMIND_PATH ) . 'includes/shopimind-log.php' );

    if( is_admin() || ( defined( 'DOING_AJAX' ) && DOING_AJAX )) {
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'includes/shopimind-json.class.php' );
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'includes/shopimind-data-functions.php' );
    }

    if( is_admin() ) {
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'admin/shopimind-admin-hooks.php' );
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'admin/shopimind-admin-functions.php' );
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'includes/shopimind-plugin-install.php' );
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'settings/wp-improved-settings.class.php' );
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'settings/wp-improved-settings-shopimind.class.php' );
    }
    else {
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'includes/shopimind-front.php' );
    }
} catch ( Exception $e ) {
}

register_activation_hook( __FILE__, 'shopimind_plugin_activate' );
function shopimind_plugin_activate() {
    shopimind_install_plugin();
}

register_deactivation_hook( __FILE__, 'shopimind_plugin_deactivate' );
function shopimind_plugin_deactivate() {

}

function shopimind_action_deactivate() {
    deactivate_plugins( plugin_basename( __FILE__ ) );
}



add_action('wp_ajax_ajaxspmq_infos', 'ajaxspmq_infos');
add_action('wp_ajax_nopriv_ajaxspmq_infos', 'ajaxspmq_infos');
function ajaxspmq_infos() {
    require_once( trailingslashit( SHOPIMIND_PATH ) . 'includes/shopimind-front.php' );
    shopimind_cookie(true);
    $spm_user_infos = json_encode(shopimind_get_user_info(true,true));
    $spm_user_infos_encode = http_build_query(shopimind_get_user_info(true));

    header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
    echo
    json_encode([
        'spm_user_infos' => $spm_user_infos,
        'spm_user_infos_encode' => $spm_user_infos_encode
    ]);
    exit;
}

// Activer la capture du locale utilisateur uniquement si Polylang est présent
add_action('plugins_loaded', function () {
    if ( ! function_exists('pll_current_language') ) {
        return; // Polylang absent → on ne fait rien
    }

    /**
     * Construit un locale "ll_CC" (ex: fr_FR) ou retourne '' si pays introuvable.
     * - langue: Polylang courant (sinon get_locale())
     * - pays: billing -> shipping -> dernière commande -> pays de base WC
     */
    $build_locale = function ($user_id) {
        try {
            // Langue (ll)
            $lang = function_exists('pll_current_language') ? pll_current_language() : substr(\get_locale(), 0, 2);
            $lang = strtolower($lang);

            // Pays (CC) — initialisation
            $country = '';
            // Pays depuis l'adresse client
            if (class_exists('\WC_Customer')) {
                $customer = new \WC_Customer($user_id);
                if ($customer) {
                    $country = strtoupper((string) $customer->get_billing_country());
                    if (empty($country)) {
                        $country = strtoupper((string) $customer->get_shipping_country());
                    }

                }
            }

            // Dernière commande du client → pays de facturation
            if (empty($country) && function_exists('wc_get_orders')) {
                $order_ids = \wc_get_orders([
                    'customer' => $user_id,
                    'limit'    => 1,
                    'orderby'  => 'date',
                    'order'    => 'DESC',
                    'return'   => 'ids',
                ]);
                if (!empty($order_ids)) {
                    $order = \wc_get_order($order_ids[0]);
                    if ($order) {
                        $country = strtoupper((string) $order->get_billing_country());
                    }
                }
            }

            // Avant-dernier fallback : pays depuis la locale navigateur (ex: fr-FR → FR)
            if (empty($country) && !empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
                $langs = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
                if (!empty($langs[0])) {
                    $primary = str_replace('-', '_', trim($langs[0])); // fr_FR
                    $parts = explode('_', $primary);
                    if (!empty($parts[1])) {
                        $cc = strtoupper(substr(preg_replace('/[^A-Za-z]/', '', $parts[1]), 0, 2));
                        if (strlen($cc) === 2) {
                            $country = $cc;
                        }
                    }
                }
            }

            // Fallback final : pays de base WooCommerce
            if (empty($country) && function_exists('WC') && \WC()->countries) {
                $country = strtoupper((string) \WC()->countries->get_base_country());
            }

            // Si toujours vide, on n’écrase pas spm_locale
            if (empty($country)) {
                return '';
            }

            return $lang . '_' . $country; // ex: fr_FR
        } catch (\Throwable $e) {
            return '';
        }
    };


    // À l’inscription : stocke le locale utilisateur (ex. fr_FR)
    add_action('user_register', function ($user_id) use ($build_locale) {
        $locale = $build_locale($user_id);
        if ($locale !== '') {
            \update_user_meta($user_id, 'spm_locale', $locale);
        }
    }, 10, 1);

    // À la connexion : mets à jour si le locale a réellement changé (langue/pays)
    add_action('wp_login', function ($user_login, $user) use ($build_locale) {
        $current = (string) \get_user_meta($user->ID, 'spm_locale', true);
        $locale  = $build_locale($user->ID);

        // On n’écrase pas si on n’a pas de pays fiable
        if ($locale !== '' && $locale !== $current) {
            \update_user_meta($user->ID, 'spm_locale', $locale);
        }
    }, 10, 2);

    // Recalcule spm_locale à la sauvegarde de l’adresse de facturation
    add_action('woocommerce_customer_save_address', function ($user_id, $load_address) use ($build_locale) {
        $current = (string) \get_user_meta($user_id, 'spm_locale', true);
        $locale  = $build_locale($user_id);

        if ($locale !== '' && $locale !== $current) {
            \update_user_meta($user_id, 'spm_locale', $locale);
        }
    }, 10, 2);
});
