<?php

class ShopiMindConfiguration {

	static function getPluginInstallDate() {
		return get_option('shopimind_date_first_install');
	}

	static function getAPIConfiguration() {
		$configuration = array_merge( ShopiMindConfiguration::getAPIDefinitions() );
		return apply_filters( __METHOD__, $configuration );
	}

	static function getAPIDefinitions() {
		return array(
			'header' => array(
				'client_id' 	=> 'Shopymind-Client-ID',
				'version' 		=> 'Shopymind-Client-Version',
				'build' 		=> 'Shopymind-Client-Build',
				'hmac' 			=> 'Shopymind-Token',
			),

			'get' => array(
				'relaunch'		=> 'relaunch',
				'type-request' 	=> 'type-request',
			),

			'version' => '3.1.1',

			'api' => array(
				'salt' 			=> 'zPz<j.[EaX, ]$s3gzkCW;^N.2',
                'script_url'    => 'https://app-spm.com',
				'public_url' 	=> 'https://iss.shopimind.com',
				'identifiant' 	=> ShopiMindConfiguration::getAPIUser(),
				'password' 		=> ShopiMindConfiguration::getAPIPassword(),
				'url'			=> ShopiMindConfiguration::getAPIURL(),
			),
		);
	}


	static function getSPMAdressesTableName() {
		//global $wpdb;		$name = $wpdb->prefix . 'spm_addresses';
		$name = '_spm_addresses';
		return apply_filters( __METHOD__, $name );
	}

	static function getAPIUser() {
		return apply_filters( __METHOD__, get_option( 'shopimind_api_user' ) );
	}
	static function getAPIPassword() {
		return apply_filters( __METHOD__, get_option( 'shopimind_api_password' ) );
	}
	static function getPhoneNumber() {
		return apply_filters( __METHOD__, get_option( 'shopimind_shop_phone' ) );
	}
	static function getContactPageURL() {
		$page_id = get_option( 'shopimind_shop_contact_url' );
		$permalink = get_page_link( $page_id );
		return apply_filters( __METHOD__, $permalink );
	}

	static function getAPIURL() {
		return 'https://iss.shopimind.com/rest';
	}
	static function RealTimeSync() {
		return apply_filters( __METHOD__, get_option( 'shopimind_api_realtime' ) );
	}

	static function getEmailImageFormat() {
		return apply_filters( __METHOD__, get_option( 'shopimind_email_image_format' ) );
	}

	static function useNamedCoupons() {
		return apply_filters( __METHOD__, get_option( 'shopimind_use_named_coupons' ) );
	}

	static function areCouponsCombinable() {
		return apply_filters( __METHOD__, get_option( 'shopimind_coupon_cumulative' ) );
	}

	static function getCouponsDuration() {
		return apply_filters( __METHOD__, get_option( 'shopimind_coupon_expiration' ) );
	}

	static function getUserBirthdayField() {
		return apply_filters( __METHOD__, get_option( 'shopimind_birthday_field' ) );
	}
	static function getUserGenderField() {
		return apply_filters( __METHOD__, get_option( 'shopimind_gender_field' ) );
	}

	static function getUserNewsletterField() {
		return apply_filters( __METHOD__, get_option( 'shopimind_newsletter_field' ) );
	}
	static function getProductManufacturerFieldType() {
		return apply_filters( __METHOD__, get_option( 'shopimind_manufacturer_field_type' ) );
	}
	static function getProductManufacturerField() {
		return apply_filters( __METHOD__, get_option( 'shopimind_manufacturer_field' ) );
	}
	static function getProductManufacturerTaxonomy() {
		return apply_filters( __METHOD__, get_option( 'shopimind_manufacturer_taxonomy' ) );
	}

	static function isMultiShops() {
		return apply_filters( __METHOD__, get_option( 'shopimind_wc_multi' ) );		
	}

    static function excludeOutOfStockProducts() {
        return apply_filters( __METHOD__, get_option( 'shopimind_exclude_out_of_stock_products' ) );
    }

	static function getWordPressImagesSize() {
		global $_wp_additional_image_sizes;

		$sizes = array();

		foreach ( get_intermediate_image_sizes() as $_size ) {
			if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
				$sizes[ $_size ]['width'] = get_option( "{$_size}_size_w" );
				$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
				$sizes[ $_size ]['crop'] = ( bool ) get_option( "{$_size}_crop" );
			} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
				$sizes[ $_size ] = array(
					'width' => $_wp_additional_image_sizes[ $_size ]['width'],
					'height' => $_wp_additional_image_sizes[ $_size ]['height'],
					'crop' => $_wp_additional_image_sizes[ $_size ]['crop'],
				);
			}
		}

		return $sizes;
	}

	static function shouldWeSyncSubscribers() {
		return apply_filters( __METHOD__, get_option( 'shopimind_newsletter_sync_subscribers' ) );
	}

	static function getMLSyncFields() {
		$shopimind_fields = ShopiMindConfiguration::getShopiMindSubscriberFields();
		$sync_fields = array();
		foreach( $shopimind_fields as $field ) {
			$sync_fields[$field] = get_option( 'shopimind_ml_field_' . $field );
		}
		return apply_filters( __METHOD__, $sync_fields );
	}

	static function getShopiMindSubscriberFields() {
		return apply_filters(
			'ShopiMind_getShopiMindSubscriberFields',
			array( 
				'email',
				'first_name',
				'last_name',
				'zipcode',
				'last_update',
				'newsletter',
			)
		);
	}
	
	static function execWorks() {
		return is_callable('exec') && !in_array('exec', explode(',', ini_get('disable_functions')));
	}

	static function getTableNames() {
		global $wpdb;
		$sql = "SHOW TABLES LIKE '%'";
        $results = $wpdb->get_col( $sql );

        $tables = array();
        if( $results ) foreach( $results as $table ) {
            $tables[$table] = $table;
        }

        return apply_filters( __METHOD__, $tables );
	}

	static function getMLTableName() {
		return apply_filters( __METHOD__, get_option( 'shopimind_ml_table_name' ) );
	}

	static function getMLTableFields() {
		$table = ShopiMindConfiguration::getMLTableName();
        if(!$table || empty( $table ) || $table == -1 || $table == 'none') {
			return false;
		}

		global $wpdb;
		$sql = "DESCRIBE $table";

		$all_objects = $wpdb->get_results( $sql );

		$existing_columns = [];
		foreach ( $all_objects as $object ) {
		// Build an array of Field names
		$existing_columns[] = $object->Field;
		}
		return apply_filters( __METHOD__, $existing_columns );
	}

}


//global $SHOPYMIND_CLIENT_CONFIGURATION;$SHOPYMIND_CLIENT_CONFIGURATION = array_merge( shopimind_api_definitions(), shopimind_api_configuration() );

