<?php

if( !class_exists( 'WP_Improved_Settings\WP_Improved_Settings' )) {
    require( dirname( __FILE__ ) . '/wp-improved-settings.class.php' );
}

function shopimind_admin_connectShopToSPM() {
    require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/connect.php' );
    $output = shopimind_connectShopToSPM();
    echo $output;
}

class WP_Improved_Settings_ShopiMind extends WP_Improved_Settings\WP_Improved_Settings {
    public $plugin_id = 'shopimind';
    public $option_page = 'shopimind_settings';
    public $menu_order = 54;
    public $parent_menu = 'woocommerce';
    public $defaultSettingsTab = 'parametres';
    public $minimum_capability = 'publish_posts';
    public $extendedActions = array();

    static function getPageTitle() {
        return __( 'Réglages ShopiMind', 'shopimind' );
    }

    static function getMenuTitle() {
        return __( 'ShopiMind', 'shopimind' );
    }

    function on_save() {
        update_option( 'shopimind_plugin_installed', 1 );

        if( $_REQUEST['tab'] == 'urls' ) {
            flush_rewrite_rules();
        }
    }

    function maybe_print_notices() {
        $current_screen = get_current_screen();

        if (isset($current_screen) && isset($current_screen->id)
            && in_array($current_screen->id, array('dashboard', 'woocommerce_page_shopimind_settings'))) {
            $fully_configured = shopimind_is_plugin_fully_configured();
            if( $fully_configured !== true ) {
                $class = 'notice notice-error';

                $messages = array();
                if (is_array($fully_configured)) {
                    foreach ($fully_configured as $error) {
                        if (ShopiMind\is_api_error($error)) {
                            $messages[] = sprintf(__('<li>%s</li>', 'shopimind'), $error->get_error_message());
                        } else {
                            $messages[] = sprintf(__('<li>%s</li>', 'shopimind'), $error);
                        }
                    }
                }
                $message = sprintf(
                    __('Le plugin ShopiMind n\'est pas encore configuré : <ul>%s</ul>', 'shopimind'),
                    implode("\n", $messages)
                );
                if( count( $messages )) {
                    $message .= sprintf(
                        __('<a href="%s">Merci de configurer le plugin</a>', 'shopimind'),
                        admin_url( '/admin.php?page=shopimind_settings' )
                    );
                }

                printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), ($message));
            }
        }
    }

    function getSettingsStructure() {
        $settings = array(
            'parametres'	=> array(
                'title' 	=> __( 'Réglages', 'shopimind' ),
                'sections'	=> array()
            ),
            'integration' 	=> array(
                'title' 	=> __( 'Intégration', 'shopimind' ),
                'sections'	=> array()
            ),
            'coupons'		=> array(
                'title' 	=> __( 'Codes promos', 'shopimind' ),
                'sections'	=> array()
            ),
            'newsletter'	=> array(
                'title' 	=> __( 'Liste de diffusion', 'shopimind' ),
                'sections'	=> array()
            ),
        );

        /** PARAMETRES **/
        $settings['parametres']['sections']['identifiants'] = array(
            'title' 	=> __( 'Codes d\'accès', 'shopimind' ),
            'fields'	=> array(
                array(
                    'id'		=> 'api_user',
                    'title'		=> __( 'Identifiant API' , 'shopimind' ),
                    'type'		=> 'text',
                ),
                array(
                    'id'		=> 'api_password',
                    'title'		=> __( 'Mot de passe API' , 'shopimind' ),
                    'css'		=> 'width: 17em;',
                    'type'		=> 'password',
                ),
                array(
                    'id'		=> 'shop_phone',
                    'title'		=> __( 'Téléphone' , 'shopimind' ),
                    'type'		=> 'text',
                ),
                array(
                    'id'		=> 'shop_contact_url',
                    'title'		=> __( 'Page de contact' , 'shopimind' ),
                    'type'		=> 'select',
                    'options'	=> array(),
                ),
                array(
                    'id'		=> 'exclude_out_of_stock_products',
                    'title'		=> __( 'Souhaitez-vous définir les produits en rupture de stock comme désactivés ?' , 'shopimind' ),
                    'type'		=> 'radio',
                    'values'	=> array(
                        0 	=> __( 'Non', 'shopimind' ),
                        1 	=> __( 'Oui', 'shopimind' )
                    ),
                    'default'	=> 0,
                ),
                array(
                    'id'		=> 'wc_multi',
                    'title'		=> __( 'Multi boutiques' , 'shopimind' ),
                    'type'		=> 'radio',
                    'values'	=> array(
                        0 	=> __( 'Non', 'shopimind' ),
                        1 	=> __( 'Oui', 'shopimind' )
                    ),
                    'default'	=> 0,
                ),
                array(
                    'id'		=> 'wc_multi_current',
                    'title'		=> __( 'ID de cette boutique' , 'shopimind' ),
                    'disabled'	=> true,
                    'type'		=> 'text',
                    'placeholder'	=> get_current_blog_id()
                ),
                array(
                    'id'		=> 'api_realtime',
                    'title'		=> __( 'Synchronisation temps réel' , 'shopimind' ),
                    'type'		=> 'radio',
                    'values'	=> array(
                        0 	=> __( 'Non', 'shopimind' ),
                        1 	=> __( 'Oui', 'shopimind' )
                    ),
                    'default'	=> 0,
                    'description'	=> __( 'Les données ShopiMind doivent-elles être envoyées instantanément ?', 'shopimind' )
                ),
                array(
                    'id'		=> 'cache_workaround',
                    'title'		=> __( 'Solution de contournement du cache' , 'shopimind' ),
                    'type'		=> 'radio',
                    'values'	=> array(
                        0 	=> __( 'Non', 'shopimind' ),
                        1 	=> __( 'Oui', 'shopimind' )
                    ),
                    'default'	=> 1,
                    'description'	=> __( 'Activez ce mode si vous utilisez un système de cache pleine page.', 'shopimind' )
                ),
            ),
        );

        $settings['parametres']['footer']['actions'] = array('shopimind_admin_connectShopToSPM');
        /** END PARAMETRES **/

        /** INTEGRATION **/
        $settings['integration']['sections']['images'] = array(
            'title' 	=> __( 'Images', 'shopimind' ),
            'fields'	=> array(
                array (
                    'id'		=> 'email_image_format',
                    'title'		=> __( 'Format de l\'image à utiliser dans les mails' , 'shopimind' ),
                    'type'		=> 'select',
                    'options'	=> array(),
                    'default'	=> 'thumbnail'
                )
            )
        );

        // customers
        $settings['integration']['sections']['customers'] = array(
            'title' 	=> __( 'Customers', 'shopimind' ),
            'fields'	=> array(
                array(
                    'id'		=> 'birthday_field',
                    'title'		=> __( 'Champ personnalisé de la date d\'anniversaire' , 'shopimind' ),
                    'type'		=> 'select',
                    'options'	=> array(),
                ),
                array(
                    'id'		=> 'gender_field',
                    'title'		=> __( 'Champ personnalisé du genre' , 'shopimind' ),
                    'type'		=> 'select',
                    'options'	=> array(),
                ),
                array(
                    'id'		=> 'newsletter_field',
                    'title'		=> __( 'Champ personnalisé de la newsletter' , 'shopimind' ),
                    'type'		=> 'select',
                    'options'	=> array(),
                )
            )
        );

        $settings['integration']['sections']['tracking'] = array(
            'title' 	=> __( 'Suivi utilisateurs', 'shopimind' ),
            'fields'	=> array()
        );

        // products
        $settings['integration']['sections']['manufacturer'] = array(
            'title' 	=> __( 'Fabricants', 'shopimind' ),
            'fields'	=> array(
                array(
                    'id'		=> 'manufacturer_field_type',
                    'title'		=> __( 'Type de champs indiquant le fabricant' , 'shopimind' ),
                    'type'		=> 'select',
                    'options'	=> array(
                        'none'		=> __( 'None', 'shopimind' ),
                        'meta'		=> __( 'Champ méta', 'shopimind' ),
                        'taxonomy'	=> __( 'Taxonomie', 'shopimind' ),
                    ),
                    'default'	=> 'none',
                ),
                array(
                    'id'		=> 'manufacturer_field',
                    'title'		=> __( 'Champ méta pour le fabricant' , 'shopimind' ),
                    'type'		=> 'select',
                    'options'	=> array(),
                ),
                array(
                    'id'		=> 'manufacturer_taxonomy',
                    'title'		=> __( 'Taxonomie pour le fabricant' , 'shopimind' ),
                    'type'		=> 'select',
                    'options'	=> array(),
                ),
            )
        );

        /** END INTEGRATION **/

        /** COUPONS **/
        $settings['coupons']['sections']['coupons'] = array(
            'title' 	=> __( 'Codes promos', 'shopimind' ),
            'fields'	=> array(
                array(
                    'id'		=> 'use_named_coupons',
                    'title'		=> __( 'Générer des codes promos lié aux comptes clients' , 'shopimind' ),
                    'type'		=> 'radio',
                    'values'	=> array(
                        1 			=> __( 'Oui', 'shopimind' ),
                        0 			=> __( 'Non', 'shopimind' ),
                    ),
                    'default'	=> 0,
                    'description'	=> __( 'Les codes promos ShopiMind doivent-ils être liés à un compte client ? (Si c\'est le cas, seul le client identifié pourra l\'utiliser)', 'shopimind' )
                ),
                array(
                    'id'		=> 'coupon_cumulative',
                    'title'		=> __( 'Codes promos cumulables' , 'shopimind' ),
                    'type'		=> 'radio',
                    'values'	=> array(
                        1 			=> __( 'Oui', 'shopimind' ),
                        0 			=> __( 'Non', 'shopimind' ),
                    ),
                    'default'	=> 0,
                    'description'	=> __( 'Les codes promos ShopiMind peuvent-ils s\'ajouter à d\'autres codes promos ?', 'shopimind' )
                ),
                array(
                    'id'			=> 'coupon_expiration',
                    'title'			=> __( 'Durée de vie des coupons' , 'shopimind' ),
                    'type'			=> 'number',
                    'description'	=> __( 'Les codes promos expirent au bout de N jours', 'shopimind' )
                ),
            ),
        );
        /** END COUPONS **/

        /** NEWSLETTER **/
        $settings['newsletter']['sections']['mailing_list'] = array(
            'title' 	=> __('Mailing list', 'shopimind'),
            'fields'	=> array(
                array(
                    'id'		=> 'newsletter_sync_subscribers',
                    'title'		=> __( 'Synchroniser les abonnés' , 'shopimind' ),
                    'type'		=> 'radio',
                    'values'	=> array(
                        1 	=> __('Oui', 'shopimind'),
                        0 	=> __('Non', 'shopimind'),
                    ),
                    'default'	=> 0,
                    'description'	=> __('Si vous avez une liste de souscription à la newsletter, ShopiMind peut la synchroniser dans une liste dédiée', 'shopimind')
                ),
            )
        );

        $settings['newsletter']['sections']['ml_table'] = array(
            'title' 	=> __( 'Table des abonnés', 'shopimind' ),
            'fields'	=> array(
                array(
                    'id'		=> 'ml_table_name',
                    'title'		=> __( 'Nom de la table' , 'shopimind' ),
                    'type'		=> 'select',
                    'options'	=> array(),
                    'default'	=> 'none',
                    'description'	=> __( 'La table de base de données qui contient les données d\'abonnés', 'shopimind' )
                ),
            )
        );

        if( ShopiMindConfiguration::getMLTableName() != '' ) {
            $shopimind_fields = ShopiMindConfiguration::getShopiMindSubscriberFields();
            foreach( $shopimind_fields as $shopimind_field ) {
                $settings['newsletter']['sections']['ml_table']['fields'][] = array(
                    'id'		=> 'ml_field_' . $shopimind_field,
                    'title'		=> $shopimind_field,
                    'type'		=> 'select',
                    'default'	=> '-',
                    'options'	=> array(),
                );
            }
        }

        /** END NEWSLETTER **/
        $finalSettings = apply_filters( 'shopimind_admin_configuration', $settings );
        $this->settingsStructure = $finalSettings;
        return $finalSettings;
    }
}
