<?php

/*
	Teste si le plugin est installé et configuré
	Répond ( bool ) true pour plugin installé et configuré
	Répond ( bool ) false pour plugin installé mais valeurs non configurées
*/
function shopimind_is_plugin_fully_configured() {
	$errors = array();

	require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/callback.php' );

	if( class_exists( 'ShopiMind\ShopiMindClient_CallbackOverride' ) ) {
		$ShopiMindClient_Callback = new ShopiMind\ShopiMindClient_CallbackOverride();
	}
	else {
		$ShopiMindClient_Callback = new ShopiMind\ShopiMindClient_Callback( array() );
	}

	$api_ok = $ShopiMindClient_Callback->selfCheck();
	if( ShopiMind\is_api_error( $api_ok )) {
		$errors[] = $api_ok;
	}

	if( count( $errors )) {
		return $errors;
	}

	return true;
}


function shopimind_create_table_addresses() {
	global $wpdb;
	$table_name = ShopiMindConfiguration::getSPMAdressesTableName();

	$sql = "SHOW TABLES LIKE '%$table_name%';";
	$result = $wpdb->get_results( $sql );
	if( !count( $result )) {
		$sql = "CREATE TABLE `$table_name` (
		 `id` int( 11 ) NOT NULL AUTO_INCREMENT,
		 `identifier` varchar( 255 ) COLLATE latin1_general_ci NOT NULL,
		 `first_name` varchar( 255 ) COLLATE latin1_general_ci NOT NULL,
		 `last_name` varchar( 255 ) COLLATE latin1_general_ci NOT NULL,
		 `phone1` varchar( 255 ) COLLATE latin1_general_ci DEFAULT NULL,
		 `phone2` varchar( 255 ) COLLATE latin1_general_ci DEFAULT NULL,
		 `company` varchar( 255 ) COLLATE latin1_general_ci DEFAULT NULL,
		 `address1` varchar( 255 ) COLLATE latin1_general_ci NOT NULL,
		 `address2` varchar( 255 ) COLLATE latin1_general_ci DEFAULT NULL,
		 `postcode` varchar( 255 ) COLLATE latin1_general_ci NOT NULL,
		 `city` varchar( 255 ) COLLATE latin1_general_ci NOT NULL,
		 `other` varchar( 255 ) COLLATE latin1_general_ci DEFAULT NULL,
		 PRIMARY KEY ( `id` ),
		 KEY `identifier` ( `identifier` )
		); ";
		$created = $wpdb->query( $sql );
	}
}

function shopimind_install_plugin() {
	// install addresses table
	shopimind_create_table_addresses();

	$default_options = array(
	'shopimind_coupon_expiration' => 14,
	'shopimind_date_first_install'	=> time(),
	);
	if( $default_options ) foreach( $default_options as $option_key => $option_value ) {
		if( !get_option( $option_key )) {
			update_option( $option_key, $option_value );
		}
	}

	// not installed, just defaulted
	update_option( 'shopimind_plugin_installed', 0 );
}

function shopimind_remove_plugin() {
	global $WP_Improved_Settings;
	if( !$WP_Improved_Settings ) {
		require_once( trailingslashit( SHOPIMIND_PATH ) . 'settings/wp-improved-settings-shopimind.class.php' );
 	    $WP_Improved_Settings = new WP_Improved_Settings_ShopiMind();
    }

    global $wpdb;
	$table_name = ShopiMindConfiguration::getSPMAdressesTableName();
	$sql = "DROP TABLE `$table_name`;";
	$wpdb->query( $sql );
}
