<?php

class ShopiMindJSON {
    protected $_restService = null;

    protected $Client = false;

	function __construct( $version = '', $build = 0, $sender = 'wp' ) {
        $this->setConfiguration();
        $this->setVersion( $version );
        $this->setBuild( $build );

        require_once( trailingslashit( SHOPIMIND_PATH ) . 'ShopyMindClient/SZend/Http/Client.php' );
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'ShopyMindClient/SZend/Exception.php' );
        require_once( trailingslashit( SHOPIMIND_PATH ) . 'ShopyMindClient/SZend/Json.php' );

        $this->Client = new SZend_Http_Client( $this->_definitions['api']['url'] );

        $this->setHeaders();


    }

    function setHeaders() {
		
		$this->Client->setHeaders( $this->_definitions['header']['client_id'] , $this->_definitions['api']['identifiant'] );
		$this->Client->setHeaders( $this->_definitions['header']['build']     , $this->_definitions['build'] );
		$this->Client->setHeaders( $this->_definitions['header']['version']   , $this->_definitions['version'] );
        
    }

	function setConfiguration() {
        $this->_definitions = ShopiMindConfiguration::getAPIConfiguration();
	}

	function setVersion( $version ) {
		$this->_definitions['version'] = filter_var( $version, FILTER_SANITIZE_STRING );
	}
	function setBuild( $build ) {
		$this->_definitions['build'] = intval( $build );
	}


    /**
     * Permet de récupérer le token
     *
     * @return string
     */
    public function getToken() {
        $params = $this->Client->getParams();

        if ($params !== null) {
            uksort($params, 'strnatcasecmp');
            $params = $this->implode_recursive($params);
        }

        $password = sha1($this->_definitions['api']['password']);

        return hash_hmac('sha256', $params, $password);
    }


    public function send( $data ) {

	/*	if($this->_sender == 'wp') {
			$response = wp_json_encode( $data );
			wp_send_json( $data );
			return false;
		}
*/

        $this->Client->setMethod( 'POST' );
        $this->Client->setConfig(array(
                'timeout'      => 5
            )
        );
        $token = $this->getToken();
        $this->Client->setHeaders($this->_definitions['header']['hmac'], $token);

        if ($this->getRestService() !== null) {
            $uri = $this->Client->getUri(true);
            $uri .= '/' . $this->getRestService();
            $this->Client->setUri($uri);
        }

        $response = $this->Client->request();
        //return SZend_Json::decode($response->getBody());
        return json_decode( $response->getBody(), true);
	}

	/*** ALLLLOOOO ???? ***/
	
    /**
     * Permet de récupérer le service à appeler
     *
     * @return string
     */
    public function getRestService() {
        return $this->_restService;
    }

    public function getClient() {
        return $this->Client;
    }

    /**
     * Permet de définir le service à appeler
     *
     * @param string $restService
     * @return ShopiMindClient_Client
     */
    public function setRestService($restService) {
        $this->_restService = $restService;
        return $this;
    }

    protected function formatString($value, $key, $options) {
        if (!empty($value)) {
            $options['glued_string'] .= $key.$options['glue'];
            $options['glued_string'] .= $value.$options['glue'];
        }
    }
    private function implode_recursive(array $array, $glue = ';') {
        $glued_string = '';
        // Recursively iterates array and adds key/value to glued string
        array_walk_recursive($array, array($this, 'formatString'), array('glue' => $glue, 'glued_string' => &$glued_string));
        // Removes last $glue from string
        strlen($glue) > 0 and $glued_string = substr($glued_string, 0, -strlen($glue));

        // Trim ALL whitespace
        $glued_string = preg_replace("/(\s)/ixsm", '', $glued_string);

        return (string) $glued_string;
    }
}
