<?php

function shopimind_array_trim( $input ) {
    return is_array( $input ) ? array_filter( $input,
        function ( & $value ) { return $value = shopimind_array_trim( $value ); }
    ) : $input;
}

function shopimind_value_exists($x) {
    return !(is_null($x) || !$x);
}

function shopimind_get_user_info($callFromCacheWorkaround = false, $full = false)
{
    $currentUserInfos = array();
    if (!$callFromCacheWorkaround || !(int)apply_filters( __METHOD__, get_option( 'shopimind_cache_workaround' ))) {
        $api_definitions = ShopiMindConfiguration::getAPIConfiguration();

        $currentUserInfos['spm_ident'] = $api_definitions['api']['identifiant'];
        $currentUserInfos['id_product'] = '';
        $currentUserInfos['id_category'] = '';
        $currentUserInfos['id_manufacturer'] = '';

        // 🔁 Ajout de la langue active du visiteur
        if (function_exists('pll_current_language')) {
            $currentUserInfos['language'] = pll_current_language();
        } else {
            $currentUserInfos['language'] = substr(get_locale(), 0, 2);
        }

        if (is_product()) {
            $currentUserInfos['id_product'] = get_the_ID();
        }

        if (is_product_category()) {
            global $wp_query;
            $currentUserInfos['id_category'] = $wp_query->get_queried_object()->term_id;
        }
    }
    if ($callFromCacheWorkaround || !(int)apply_filters( __METHOD__, get_option( 'shopimind_cache_workaround' ))) {
        // USER
        $user_id = get_current_user_id();
        if (isset($_COOKIE['spm_session_cart']) && $_COOKIE['spm_session_cart'] != "" && isset($_COOKIE['spm_id_cart']) && ($_COOKIE['spm_id_cart'] != "")) {
            if ($full) {
                $currentUserInfos['cart'] = json_decode(base64_decode($_COOKIE['spm_session_cart']), true);
            } else {
                $currentUserInfos['cart_hash'] = sha1(serialize(json_decode(base64_decode($_COOKIE['spm_session_cart']), true)));
            }
            $currentUserInfos['id_cart'] = $_COOKIE['spm_id_cart'];
            $currentUserInfos['id_cart_old'] = (isset($_COOKIE['spm_id_cart_old']) ? $_COOKIE['spm_id_cart_old'] : null);
        } else {
            /* Si la panier est vide */
            $currentUserInfos['id_cart'] = null;
            $currentUserInfos['id_cart_old'] = null;
            if (!$full) {
                $currentUserInfos['cart_hash'] = sha1(serialize(array()));
            }
        }
        if ($user_id) {
            $currentUserInfos['user'] = array(
                'id_customer' => $user_id,
            );
        } else {
            $currentUserInfos['user'] = null;
        }
        //Update user id if necessary
        if (isset($currentUserInfos['cart']) && is_array($currentUserInfos['cart']) && isset($currentUserInfos['cart']['id_customer']) && (int)$currentUserInfos['cart']['id_customer'] !== ($user_id)) {
            $currentUserInfos['cart']['id_customer'] = $user_id;
        }
    }



    return apply_filters('shopimind_tracking_user_infos', $currentUserInfos);
}