<?php

add_action('wp', 'shopimind_cookie');
function shopimind_cookie($force = false)
{

    if (($_POST && !$force) || (defined('DOING_AJAX') && DOING_AJAX && !$force) || headers_sent() || !did_action( 'wp_loaded' )) {
        return;
    }

    $is_ssl = filter_var(is_ssl(), FILTER_VALIDATE_BOOLEAN);
    $cookie_path = defined('COOKIEPATH') ? COOKIEPATH : false;
    $cookie_domain = defined('COOKIE_DOMAIN') ? COOKIE_DOMAIN : false;

    $user_id = get_current_user_id();
    /* Vérifier l'existance du cookie  spm_id_cart*/
    $spmidcartCookieExist = isset($_COOKIE['spm_id_cart']) && $_COOKIE['spm_id_cart'] != '';

    if(!$spmidcartCookieExist){
        $uniqidSpmCart = 'wc-cart-'.uniqid();
        /* Si utilisateur connecté, on récupére son dernier id_cart connu si existe. */
        if($user_id){
            $id_last_cart_user = get_user_meta($user_id, 'spmid_last_cart', true);
            if($id_last_cart_user && $id_last_cart_user != ""){
                $uniqidSpmCart = $id_last_cart_user;
            } else {
                add_user_meta($user_id, 'spmid_last_cart', $uniqidSpmCart, true);
            }
        }
        @setcookie('spm_id_cart', $uniqidSpmCart, time() + DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
        $_COOKIE['spm_id_cart'] = $uniqidSpmCart;
    } else {
        if($user_id){
            $id_last_cart_user = get_user_meta($user_id, 'spmid_last_cart', true);
            if(!$id_last_cart_user || $id_last_cart_user == ""){
                add_user_meta($user_id, 'spmid_last_cart', $_COOKIE['spm_id_cart'], true);
                $id_last_cart_user = $_COOKIE['spm_id_cart'];
            } else {
                // if cookie spm_id_cart_old doesn't exist or is empty, we set spm_id_cart_old with spm_id_cart
                if ((!isset($_COOKIE['spm_id_cart_old']) || $_COOKIE['spm_id_cart_old'] == "") && $_COOKIE['spm_id_cart'] != $id_last_cart_user) {
                    @setcookie('spm_id_cart_old', $_COOKIE['spm_id_cart'], time() + DAY_IN_SECONDS, $cookie_path,
                        $cookie_domain, $is_ssl);
                    $_COOKIE['spm_id_cart_old'] = $_COOKIE['spm_id_cart'];
                }
            }
        } else {
            $id_last_cart_user = $_COOKIE['spm_id_cart'];
        }
        /* renouveller la durée d'expiration du cookie */
        @setcookie('spm_id_cart', $id_last_cart_user, time() + DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
        $_COOKIE['spm_id_cart'] = $id_last_cart_user;
    }



    /* On met le panier en session si necessaire */
    if (isset($_COOKIE['woocommerce_cart_hash']) && (!isset($_COOKIE['spm_session_cart']) || !isset($_COOKIE['spm_hash_cart']) || $_COOKIE['spm_hash_cart'] !== $_COOKIE['woocommerce_cart_hash'])) {
        if (is_object(WC()) && is_object( WC()->cart)) {
            if(version_compare(WC()->version, '3.2.0', '<')) {
                // INIT CART
                WC()->cart->init( );
            }
            $WC_Cart = WC()->cart;
            $woocommerce_tax_display_cart = get_option('woocommerce_tax_display_cart');
            $vouchers = $WC_Cart->get_applied_coupons();
            $get_coupon_discount_totals = version_compare(WC()->version, '3.2.0', '>=') ? $WC_Cart->get_coupon_discount_totals() : (array) $WC_Cart->coupon_discount_amounts;
            $get_coupon_discount_tax_totals = version_compare(WC()->version, '3.2.0', '>=') ? $WC_Cart->get_coupon_discount_tax_totals() : (array) $WC_Cart->coupon_discount_tax_amounts;

            $vouchers_amount = 0;
            if (count($vouchers)) {
                $vouchers_amount = array_sum($get_coupon_discount_totals);
                if ($woocommerce_tax_display_cart == 'incl') {
                    $vouchers_amount += array_sum($get_coupon_discount_tax_totals);
                }
            }

            /* Récupérer le taux TVA
            */
            $get_tax_totals = $WC_Cart->get_tax_totals();
            $get_tax_totals = (is_array($get_tax_totals) && count($get_tax_totals) > 0) ? array_pop($get_tax_totals) : null;
            $get_rate_id = (!is_null($get_tax_totals)) ? $get_tax_totals->tax_rate_id : null;
            if(!is_null($get_rate_id)){
                $get_tax_rate = WC_Tax::_get_tax_rate($get_rate_id);
                $get_tax_rate = $get_tax_rate['tax_rate'];
            } else {
                $get_tax_rate = 1;
            }

            $amountCart = (version_compare(WC()->version, '3.2.0', '>=') ? $WC_Cart->get_total('api') : $WC_Cart->total);

            if(isset($_COOKIE['spm_session_cart']) && $_COOKIE['spm_session_cart'] != "") {
                $currentOldCart = json_decode(base64_decode($_COOKIE['spm_session_cart']), true);
                $spmCartDateAdd = $currentOldCart['date_add'];
                $spmCartDateUpd = date('Y-m-d H:i:s');

            }else {
                $spmCartDateAdd = $spmCartDateUpd = date('Y-m-d H:i:s');
            }

            $currentUserInfos['cart'] = array(
                'id_customer' => htmlentities($user_id, ENT_COMPAT, 'UTF-8'),
                'id_cart' => (string)$_COOKIE['spm_id_cart'],
                'date_add' => $spmCartDateAdd,
                'date_upd' => $spmCartDateUpd,
                'amount' => (string)$amountCart,
                'tax_rate' => (string)$get_tax_rate,
                'currency' => get_woocommerce_currency(),
                'voucher_used' => $vouchers,
                'voucher_amount' => (string)$vouchers_amount
            );
            $default_lang = function_exists('pll_default_language') ? pll_default_language() : null;
            if ($cart_items = $WC_Cart->get_cart()) {
                foreach ($cart_items as $cart_item_key => $cart_item) {
                    $WC_Product = $cart_item['data'];
                    if ($woocommerce_tax_display_cart === 'incl') {
                        $price = $cart_item['line_subtotal'] + $cart_item['line_subtotal_tax'];
                    } else {
                        $price = $cart_item['line_subtotal'];
                    }
                    if($price == 0 && !in_array($WC_Product->get_type(),array( 'simple', 'external', 'variable', 'grouped' ))) {
                        continue;
                    }
                    $product_id = $WC_Product->get_id();
                    $variation_id = 0;
                    if ($WC_Product->get_parent_id() != 0) {
                        $product_id = $WC_Product->get_parent_id();
                        $variation_id = $WC_Product->get_id();

                    }
                    // 🔁 Adaptation Polylang
                    if ($default_lang && function_exists('pll_get_post')) {
                        $translated_product_id = pll_get_post($product_id, $default_lang);
                        if ($translated_product_id) {
                            $product_id = $translated_product_id;
                        }
                    }
                    $currentUserInfos['cart']['products'][] = array(
                        'id_product' => (string)$product_id,
                        'id_combination' => (string)$variation_id,
                        'id_manufacturer' => '',
                        'qty' => (string)$cart_item['quantity'],
                        'price' => (string)floatval($price),
                        'price_without_tax' => (string)floatval($cart_item['line_subtotal']),
                    );
                }
            } else {
                $currentUserInfos['cart']['products'] = null;
            }

            $spmCartEncoded = base64_encode(json_encode($currentUserInfos['cart']));
            /* renouveller des cookie carts */
            @setcookie('spm_session_cart', $spmCartEncoded, time() + DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
            $_COOKIE['spm_session_cart'] = $spmCartEncoded;
            @setcookie('spm_hash_cart', $_COOKIE['woocommerce_cart_hash'], time() + DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
            $_COOKIE['spm_hash_cart'] = $_COOKIE['woocommerce_cart_hash'];
        }
    }elseif(!isset($_COOKIE['woocommerce_cart_hash']) && isset($_COOKIE['spm_hash_cart'])) {
        @setcookie('spm_session_cart', base64_encode(json_encode(array())), time() + DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
        $_COOKIE['spm_session_cart'] = base64_encode(json_encode(array()));
    }
}

add_action('wp_footer', 'shopimind_add_tracking');
function shopimind_add_tracking()
{
    if (is_admin()) {
        return;
    }

    $code = shopimind_generate_tracking_code();
    echo $code;
}

add_action( 'woocommerce_thankyou', 'action_woocommerce_thankyou');
function action_woocommerce_thankyou($order_get_id){
    /* Dés que la commande est effectué, on affecte l'id_last_cart à la commande en question
        et en supprime cette meta de l'utilisateur */
    $is_ssl = filter_var(is_ssl(), FILTER_VALIDATE_BOOLEAN);
    $cookie_path = defined('COOKIEPATH') ? COOKIEPATH : false;
    $cookie_domain = defined('COOKIE_DOMAIN') ? COOKIE_DOMAIN : false;

    $user_id = get_current_user_id();
    $useCookie = true;
    if ($user_id && metadata_exists('user', $user_id, 'spmid_last_cart')){
        $id_last_cart_user = get_user_meta($user_id, 'spmid_last_cart', true);
        delete_user_meta($user_id, 'spmid_last_cart');
        add_post_meta($order_get_id, 'spmid_cart_order', $id_last_cart_user, true);
        $useCookie = false;
    }

    if ($useCookie && isset($_COOKIE['spm_id_cart']) && $_COOKIE['spm_id_cart'] != '') {
        add_post_meta($order_get_id, 'spmid_cart_order', $_COOKIE['spm_id_cart'], true);
    }


    @setcookie('spm_id_cart', '', time() - DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
    @setcookie('spm_id_cart_old', '', time() - DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
    @setcookie('spm_session_cart', '', time() - DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
    @setcookie('spm_hash_cart', '', time() - DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
    unset($_COOKIE['spm_session_cart']);
    unset($_COOKIE['spm_hash_cart']);
    unset($_COOKIE['spm_id_cart']);
    unset($_COOKIE['spm_id_cart_old']);

    $action = $id = $table = false;
    $action = "saveOrder";
    $id = $order_get_id;
    $call_args = compact('action', 'id', 'table');
    $unique_key = 'spm_' . md5('shopimind_instant_call_action' . serialize($call_args));
    as_enqueue_async_action('shopimind_instant_call_action', [$action, $id, $table], 'shopimind', $unique_key);
}

add_action( 'woocommerce_checkout_order_processed', 'action_woocommerce_checkout_process',  1, 1);
function action_woocommerce_checkout_process($order_get_id){
    /* Dés que la commande est effectué, on affecte l'id_last_cart à la commande en question
        et en supprime cette meta de l'utilisateur */
    $is_ssl = filter_var(is_ssl(), FILTER_VALIDATE_BOOLEAN);
    $cookie_path = defined('COOKIEPATH') ? COOKIEPATH : false;
    $cookie_domain = defined('COOKIE_DOMAIN') ? COOKIE_DOMAIN : false;

    $user_id = get_current_user_id();

    $useCookie = true;
    if ($user_id && metadata_exists('user', $user_id, 'spmid_last_cart')){
        $id_last_cart_user = get_user_meta($user_id, 'spmid_last_cart', true);
        delete_user_meta($user_id, 'spmid_last_cart');
        add_post_meta($order_get_id, 'spmid_cart_order', $id_last_cart_user, true);
        $useCookie = false;
    }

    if ($useCookie && isset($_COOKIE['spm_id_cart'])) {
        add_post_meta($order_get_id, 'spmid_cart_order', $_COOKIE['spm_id_cart'], true);
    }

    @setcookie('spm_id_cart', '', time() - DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
    @setcookie('spm_id_cart_old', '', time() - DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
    @setcookie('spm_session_cart', '', time() - DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
    @setcookie('spm_hash_cart', '', time() - DAY_IN_SECONDS, $cookie_path, $cookie_domain, $is_ssl);
    unset($_COOKIE['spm_session_cart']);
    unset($_COOKIE['spm_hash_cart']);
    unset($_COOKIE['spm_id_cart']);
    unset($_COOKIE['spm_id_cart_old']);
}

function shopimind_generate_tracking_code()
{
    $api_definitions = ShopiMindConfiguration::getAPIConfiguration();

    if ((int)apply_filters( __METHOD__, get_option( 'shopimind_cache_workaround' ))) {
        $html = "<script type=\"text/javascript\">
        var xmlhttp = new XMLHttpRequest();
		var _spmq = {};
        var _spmq_nc = %USER_INFO_ENCODE%;
		xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
        try {
                var data = JSON.parse(xmlhttp.responseText); 
            } catch(err) {
                return;
            }
            var _spmq_c = JSON.parse(data.spm_user_infos);
            Object.keys(_spmq_nc).forEach(key => _spmq[key] = _spmq_nc[key]);
            Object.keys(_spmq_c).forEach(key => _spmq[key] = _spmq_c[key]);
             _spmq.url = window.location.href.replace(/^https?:/, '');
            var _spmq_encode = data.spm_user_infos_encode;
            var _spm_id_combination = function() {
                return (typeof(document.getElementById('idCombination')) != 'undefined' && document.getElementById('idCombination') != null ?
                        document.getElementById('idCombination').value : ''
                );
            };
            ( function() {
		 var spm = document.createElement( 'script' );
		 spm.type = 'text/javascript';
		 spm.async = true;
		 var currentUrlParam = encodeURIComponent(_spmq.url);
                spm.src = '%SPM_URL%/app.js?%USER_INFO%' 
                    + (typeof _spmq_encode === 'string' && _spmq_encode ? '&' + _spmq_encode : '') 
                    + '&id_combination=' + _spm_id_combination() 
                    + '&url=' + currentUrlParam;
		 var s_spm = document.getElementsByTagName( 'script' )[0];
		 s_spm.parentNode.insertBefore( spm, s_spm );
		} )();
        }
        };
        xmlhttp.open('POST', '" . admin_url('admin-ajax.php') . "', true);
        //Send the proper header information along with the request
    xmlhttp.setRequestHeader('Content-type', 'application/x-www-form-urlencoded')
    xmlhttp.send('action=ajaxspmq_infos');
	</script>";
    } else {
        $html = "<script type=\"text/javascript\">
            var _spmq = %USER_INFO_ENCODE%;
            _spmq.url = window.location.href.replace(/^https?:/, '');
            var _spm_id_combination = function() { return ( typeof( document.getElementById( 'idCombination' )) != 'undefined' && document.getElementById( 'idCombination' ) != null ? document.getElementById( 'idCombination' ).value:'' );};
            ( function() {
             var spm = document.createElement( 'script' );
             spm.type = 'text/javascript';
             spm.async = true;
             var currentUrlParam = encodeURIComponent(_spmq.url);
             spm.src = '%SPM_URL%/app.js?%USER_INFO%&id_combination=' + _spm_id_combination() + '&url=' + currentUrlParam;
             var s_spm = document.getElementsByTagName( 'script' )[0];
             s_spm.parentNode.insertBefore( spm, s_spm );
            } )();
        </script>";
    }
    $user_infos = shopimind_get_user_info();

    if (get_option('spm_script_url') && get_option('spm_script_url') != ""){
        $SPM_URL = get_option('spm_script_url');
    } else {
        $SPM_URL = $api_definitions['api']['script_url'];
    }

    $replacements = array(
        'USER_INFO' => http_build_query($user_infos),
        'SPM_URL' => $SPM_URL,
        'USER_INFO_ENCODE' => json_encode($user_infos),
    );

    $html = apply_filters('shopimind_tracking_raw', $html);
    $replacements = apply_filters('shopimind_tracking_replacements', $replacements);
    foreach ($replacements as $key => $value) {
        $html = str_replace("%$key%", $value, $html);
    }
    $html = apply_filters('shopimind_tracking_code', $html);
    return $html;
}