<?php

function shopimind_get_possible_shippings() {
	global $wpdb;

	$sql = "SELECT szm.instance_id, szm.method_id, sz.zone_name, sz.zone_id
		FROM {$wpdb->prefix}woocommerce_shipping_zone_methods szm
		LEFT JOIN {$wpdb->prefix}woocommerce_shipping_zones sz ON sz.zone_id = szm.zone_id
		WHERE szm.is_enabled = 1
		ORDER BY szm.zone_id, szm.method_order";
	$results = $wpdb->get_results( $sql );
	$shippings = array();
	if( $results ) {
		foreach( $results as $result ) {
			$option_key = 'woocommerce_' . $result->method_id . '_' . $result->instance_id . '_settings';
			$instance_settings = get_option( $option_key );
			$shippings[$result->instance_id] = array(
				'zone_id' 	=> $result->zone_id,
				'zone_name' => $result->zone_name,
				'method_id' => $result->method_id,
				'title' 	=> (is_array($instance_settings) && isset($instance_settings['title']) ? $instance_settings['title']:''),
			);
		}
	}
	return $shippings;
}
