<?php
/**
 * Principes généraux
 * Hooks sur les évènements WooCommerce
 * création, suppression, édition
 * de :
 * customer, customer group, order, category , product, fabricant, shipping, voucher
 *
 * Sur ces hooks,
 * si exec permis sur le serveur : exec d'un wget sur asyncCall.php
 * sinon : appel de la méthode correspondante directement dans callback
 */

/**
saveOrder
saveProductCategory
deleteProductCategory
saveCustomerGroup
deleteCustomerGroup
saveManufacturer
deleteManufacturer
saveCarrier
deleteCarrier
saveVoucher
deleteVoucher
saveOrderStatus
deleteOrderStatus
saveProduct
deleteProduct
saveCustomer
deleteCustomer
getTableFields
 */

add_action( 'init', 'shopimind_maybe_hook_async');

function shopimind_maybe_hook_async() {
    add_action( 'save_post'									, 'shopimind_instant_update');
    add_action( 'untrash_post'								, 'shopimind_instant_update');
    add_action( 'woocommerce_update_customer'				, 'shopimind_instant_update');
    add_action( 'woocommerce_delete_customer'				, 'shopimind_instant_update');
    add_action( 'woocommerce_update_order'					, 'shopimind_instant_update');
    add_action( 'woocommerce_customer_save_address'			, 'shopimind_instant_update');



    add_action('shopimind_instant_call_action', 'shopimind_instant_call', 10, 3);

    if(!ShopiMindConfiguration::RealTimeSync()) {
        return;
    }

    add_action( 'woocommerce_delete_shipping_zone_method'	, 'shopimind_instant_update');

    add_action( 'woocommerce_trash_product'					, 'shopimind_instant_update');
    add_action( 'woocommerce_delete_product'				, 'shopimind_instant_update');
    add_action( 'woocommerce_trash_product_variation'		, 'shopimind_instant_update');
    add_action( 'woocommerce_before_delete_product_variation'		, 'shopimind_instant_update');

    add_action( 'woocommerce_update_coupon'					, 'shopimind_instant_update');
    add_action( 'woocommerce_trash_coupon'					, 'shopimind_instant_update');
    add_action( 'woocommerce_removed_coupon'				, 'shopimind_instant_update' );

    add_action( 'wp_trash_post'								, 'shopimind_instant_update');
    add_action( 'delete_post'								, 'shopimind_instant_update');

    add_action( 'woocommerce_api_create_product_category'	, 'shopimind_instant_update');
    add_action( 'woocommerce_api_delete_product_category'	, 'shopimind_instant_update');
    add_action( 'woocommerce_api_edit_product_category'		, 'shopimind_instant_update');

    add_action( 'create_product_cat'						, 'shopimind_instant_update');
    add_action( 'update_product_cat'						, 'shopimind_instant_update');
    add_action( 'edited_product_cat'						, 'shopimind_instant_update');
    add_action( 'delete_product_cat'						, 'shopimind_instant_update');

    add_action( 'woocommerce_shipping_classes_save_class'	, 'shopimind_instant_update');
    add_action( 'woocommerce_shipping_zone_method_added	'	, 'shopimind_instant_update');
    add_action( 'woocommerce_shipping_zone_method_deleted'	, 'shopimind_instant_update');

    add_action( 'edit_user_profile_update'					, 'shopimind_instant_update' );
    add_action( 'profile_update'							, 'shopimind_instant_update' );
    add_action( 'delete_user'								, 'shopimind_instant_update' );

    // TODO: use transients to avoid duplicate calls
    // add_action('shopimind_instant_call_action_after', 'clear_scheduled_action_transient');
}

function shopimind_instant_update() {
    $args = func_get_args();
    $hook = current_action();
    $action = $id = $table = false;

    switch ($hook) {
        case 'edit_user_profile_update' :
        case 'profile_update' :
        case 'woocommerce_update_customer':
        case 'woocommerce_customer_save_address':
            $action = 'saveCustomer';
            $id = $args[0];
            break;
        case 'woocommerce_delete_customer':
        case 'delete_user' :
            $action = 'deleteCustomer';
            $id = $args[0];
            break;
        case 'woocommerce_trash_product_variation' :
        case 'woocommerce_before_delete_product_variation' :
            $action = 'saveProduct';
            $WC_Product = \wc_get_product($args[0]);
            $id = $WC_Product ? $WC_Product->get_parent_id() : 0;
            break;
        case 'woocommerce_update_coupon' :
            $action = 'saveVoucher';
            $id = $args[0];
            break;
        case 'save_post' :
        case 'untrash_post' :
            $post_id = $args[0];
            $post_type = get_post_type( $post_id );
            if(!in_array( $post_type , array( 'shop_order', 'product'))) {
                return false;
            }
            if( $post_type == 'shop_order' ) {
                $action = 'saveOrder';
            }
            else {
                $action = 'saveProduct';
            }
            $id = $post_id;
            break;
        case 'woocommerce_trash_product' :
        case 'wp_trash_post' :
        case 'wp_delete_post' :
        case 'trash_post' :
        case 'delete_post' :
        case 'woocommerce_delete_product' :
            $post_id = $args[0];
            $post_type = get_post_type( $post_id );
            if(!in_array( $post_type , array( 'shop_order', 'shop_coupon', 'product', 'product_variation' ))) {
                return false;
            }
            if( $post_type == 'shop_order' ) {
                $action = 'deleteOrder';
            }
            elseif( $post_type == 'shop_coupon' ) {
                $action = 'deleteVoucher';
            }
            else {
                $action = 'deleteProduct';
            }
            $id = $post_id;
            break;
        case 'woocommerce_trash_coupon' :
        case 'woocommerce_removed_coupon' :
            $action = 'deleteVoucher';
            $id = $args[0];
            break;
        case 'woocommerce_api_create_product_category' :
        case 'woocommerce_api_edit_product_category' :
        case 'create_product_cat' :
        case 'update_product_cat' :
        case 'edited_product_cat' :
            $action = 'saveProductCategory';
            $id = $args[0];
            break;
        case 'delete_product_cat' :
        case 'woocommerce_api_delete_product_category' :
            $action = 'deleteProductCategory';
            $id = $args[0];
            break;
        case 'woocommerce_shipping_zone_method_added' :
        case 'woocommerce_shipping_classes_save_class' :
            $action = 'saveCarrier';
            $id = $args[0];
            break;
        case 'woocommerce_delete_shipping_zone_method':
        case 'woocommerce_shipping_zone_method_deleted' :
            $action = 'deleteCarrier';
            $id = $args[0];
            break;
        case 'woocommerce_update_order' :
            $action = 'saveOrder';
            $id = $args[0];
            break;
        default:
            break;
    }

    if ($action && $id > 0) {
        $call_args = compact('action', 'id', 'table');
        // TODO: use transients to avoid duplicate calls
        // Vérifier si l'action est déjà planifiée
//        if (!is_action_already_queued('shopimind_instant_call_action', $call_args, 'shopimind')) {
//            // Planifier l'action asynchrone si elle n'est pas déjà en file d'attente
//            as_enqueue_async_action('shopimind_instant_call_action', $call_args, 'shopimind');
//        }

        $unique_key = 'spm_' . md5('shopimind_instant_call_action' . serialize($call_args));
        as_enqueue_async_action('shopimind_instant_call_action', [$action, $id, $table], 'shopimind', $unique_key);
    }
}

function shopimind_instant_call($action, $id, $table) {
    $args = compact('action', 'id', 'table');

    $argsOrigin = $args;
    $defaults = array(
        'action'	=> false,
        'id'		=> false,
        'table'		=> false,
    );
    $args = wp_parse_args( $args, $defaults );

    if(!ShopiMindConfiguration::RealTimeSync() &&
        !in_array($args['action'], array('saveOrder','saveCustomer'))) {
        return;
    }

    if(ShopiMindConfiguration::execWorks()) {
        array_filter($args, 'shopimind_value_exists');
        $url = trailingslashit( SHOPIMIND_URL ) . 'asyncCall.php';
        $url .= '?' . http_build_query( $args );
        $exec = 'wget --no-check-certificate -q "'.$url.'" -O /dev/null > /dev/null 2>&1 &';

        exec($exec);
    }
    else {
        extract( $args );
        if(class_exists('ShopiMind\ShopiMindPusher_CallbackOverride')) {
            $ShopiMindPusher_Callback = new ShopiMind\ShopiMindPusher_CallbackOverride();
        }
        else {
            require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/pusher.php' );
            $ShopiMindPusher_Callback = new ShopiMind\ShopiMindPusher_Callback();
        }

        if(method_exists($ShopiMindPusher_Callback, $action )) {
            $ShopiMindPusher_Callback->$action( $id );
        }
        else {
            $blog_ids = array( \get_current_blog_id() );
            if( in_array( $action, array ('saveCustomer','deleteCustomer') ) ) {
                $blog_ids = \get_blogs_of_user($id);
            }

            if( in_array( $action, array( 'deleteCustomer', 'deleteCustomerGroup', 'deleteProduct', 'deleteProductCategory', 'deleteManufacturer', 'deleteCarrier', 'deleteVoucher', 'deleteOrderStatus' ) ) ) {
                $id = array( $id );
            }
            $ShopiMindPusher_Callback->generic_call( $blog_ids, $action, $id );
        }
    }

    // TODO: use transients to avoid duplicate calls
    //do_action('shopimind_instant_call_action_after', $args);
}

// TODO: use transients to avoid duplicate calls
//function is_action_already_queued($hook, $args, $group) {
//    $transient_key = 'spm_' . md5($hook . serialize($args));
//    $cached_result = get_transient($transient_key);
//
//    if ($cached_result !== false) {
//        // Retourner le résultat mis en cache
//        return $cached_result;
//    } else {
//        // Pas de résultat en cache, effectuer une requête
//        $queued_actions = as_get_scheduled_actions(array(
//            'hook' => $hook,
//            'group' => $group,
//            'args' => $args,
//            'status' => ActionScheduler_Store::STATUS_PENDING
//        ), 'ids');
//
//        $is_queued = !empty($queued_actions);
//        // Mettre en cache le résultat pour une durée définie
//        set_transient($transient_key, $is_queued, 600);
//
//        return $is_queued;
//    }
//}

// TODO: use transients to avoid duplicate calls
//function clear_scheduled_action_transient($args) {
//    $transient_key = 'spm_' . md5('shopimind_instant_call_action' . serialize($args));
//    delete_transient($transient_key);
//}
