<?php
// Load WordPress
define( 'DOING_AJAX', true );


$parse_uri = explode( 'wp-content', $_SERVER['SCRIPT_FILENAME'] );
$wp_load_dir = $parse_uri[0] . 'wp-load.php';

if (!file_exists($wp_load_dir)) {
    $wpLoadPath = dirname(__FILE__);
    $wpLoadPathFile = $wpLoadPath.'/wpLoadPath.php';
    if(file_exists($wpLoadPathFile)) {
        require_once($wpLoadPathFile);
    }
    if (!file_exists($wp_load_dir)) {
        function get_wp_abspath($filename)
        {
            $_DIR = __DIR__;
            $_FILE = $_DIR . '/' . $filename;

            while (!file_exists($_FILE)) {
                $_DIR = dirname($_DIR);
                $_FILE = $_DIR . '/' . $filename;
                if ($_DIR == '/') return FALSE;
            }

            return $_FILE;
        }

        $wp_load_dir = get_wp_abspath('wp-load.php');
        if(file_exists($wp_load_dir) && is_writable($wpLoadPath)) {
            file_put_contents($wpLoadPathFile,'<?php $wp_load_dir = "'.$wp_load_dir.'";?>');
        }
    }
}
require_once($wp_load_dir);

// Load API Server class
require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/apiserver.class.php' );
require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/error.class.php' );
require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/pusher.php' );


if(class_exists('ShopiMind\ShopiMindPusher_CallbackOverride')) {
	$class_name = "ShopiMind\ShopiMindPusher_CallbackOverride";
}
else {
	$class_name = "ShopiMind\ShopiMindPusher_Callback";
}

$MethodsElement = new $class_name();

$action = ( isset( $_GET['action'] ) ) ? filter_var( $_GET['action'], FILTER_SANITIZE_STRING ) : false;
$id = ( isset( $_GET['id'] ) ) ? filter_var( $_GET['id'], FILTER_SANITIZE_STRING ) : false;
$table = ( isset( $_GET['table'] ) ) ? filter_var( $_GET['table'], FILTER_SANITIZE_STRING ) : false;

if( $action && $action == 'saveOrder' ) {
	// skip order updates less than 10 seconds apart
	$last_update = get_post_meta( $id, 'last_update', true );
	if( $last_update && $last_update + 10 > time() ) {
		exit;
	}
	update_post_meta( $id, 'last_update', time() );
}
if( $action ) {

	switch($action) {
		case 'saveOrder':
		case 'saveProductCategory':
		case 'deleteProductCategory':
		case 'saveCustomerGroup':
		case 'deleteCustomerGroup':
		case 'saveManufacturer':
		case 'deleteManufacturer':
		case 'saveCarrier':
		case 'deleteCarrier':
		case 'saveVoucher':
		case 'deleteVoucher':
		case 'saveOrderStatus':
		case 'deleteOrderStatus':
		case 'saveProduct':
		case 'deleteProduct':
		case 'saveCustomer':
        case 'deleteCustomer':
        	try {
        		$return = $MethodsElement->generic_call( array( get_current_blog_id() ), $action, $id );
        	} catch (Exception $e) {
        		$return = false;
        	}
			break;
        case 'getTableFields':
            echo $return = $MethodsElement->getTableFields( $table );
            break;
		default:
			break;
	}

	if($return) {
		$MethodsElement->sendSuccess($return);
	}
	else {
		$MethodsElement->sendError();
	}
}
exit;
