<?php
namespace ShopiMind;

if( !class_exists( 'APIServer' ) ) {
	require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/apiserver.class.php' );
}

require_once( trailingslashit( SHOPIMIND_PATH ) . '/ShopyMindClient/bin/Notify.php');
class ShopiMindPusher_Callback extends APIServer {
	protected $_methods 	= array(
		'saveOrder'				=> array( 'blogid', 'id' ),
		'saveProductCategory'	=> array( 'blogid', 'id' ),
		'deleteProductCategory'	=> array( 'blogid', 'id' ),
		'saveCustomerGroup'		=> array( 'blogid', 'id' ),
		'deleteCustomerGroup'	=> array( 'blogid', 'id' ),
		'saveManufacturer'		=> array( 'blogid', 'id' ),
		'deleteManufacturer'	=> array( 'blogid', 'id' ),
		'saveCarrier'			=> array( 'blogid', 'id' ),
		'deleteCarrier'			=> array( 'blogid', 'id' ),
		'saveVoucher'			=> array( 'blogid', 'id' ),
		'deleteVoucher'			=> array( 'blogid', 'id' ),
		'saveOrderStatus'		=> array( 'blogid', 'id' ),
		'deleteOrderStatus'		=> array( 'blogid', 'id' ),
		'saveProduct'			=> array( 'blogid', 'id' ),
		'deleteProduct'			=> array( 'blogid', 'id' ),
		'saveCustomer'			=> array( 'blogid', 'id' ),
		'deleteCustomer'		=> array( 'blogid', 'id' ),
		'getTableFields'		=> array( 'blogid', 'table' ),
	);

    public function generic_call( $blog_ids, $action, $id ) {
        if( !method_exists( '\ShopymindClient_Notify', $action ) ) {
            return false;
        }

        if( in_array( $action, array(
                'deleteCustomer',
                'deleteCustomerGroup',
                'deleteProduct',
                'deleteProductCategory',
                'deleteManufacturer',
                'deleteCarrier',
                'deleteVoucher',
                'deleteOrderStatus'
            )
        )) {
            \ShopymindClient_Notify::$action( array ($id ) );
        }
        else {
            \ShopymindClient_Notify::$action($id);
        }

        return true;
    }


} 
