<?php

if(!class_exists('ShopiMind\ShopiMindClient_Callback')) {
    require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/callback.php' );
}

if( !class_exists( 'ShopymindClient_Configuration' ) ) {
	require_once( trailingslashit( SHOPIMIND_PATH ) . 'ShopyMindClient/bin/Configuration.php' );
}

function shopimind_connectShopToSPM( $new_activation = false ) {
        $configuration = ShopiMindConfiguration::getAPIDefinitions();
        $apiIdentification  = $configuration['api']['identifiant'];
        $apiPassword        = $configuration['api']['password'];

        if (! $apiIdentification || ! $apiPassword)
            return;


        $defaultCurrency = get_woocommerce_currency();

        $shop_id_shop = get_current_blog_id();
        
        $timezone = get_option('timezone_string');

        $defaultLang = substr( get_locale(), 0, 2);
        
        $forceSyncProducts = false;

        global $woocommerce;
        $woocommerce_version = $woocommerce->version;

        if(class_exists('ShopiMind\ShopiMindClient_CallbackOverride')) {
            $ShopiMindClient_Callback = new ShopiMind\ShopiMindClient_CallbackOverride( $_REQUEST );
        }
        else {
            $ShopiMindClient_Callback = new ShopiMind\ShopiMindClient_Callback( $_REQUEST );
        }

        // Récupération d'un instance et renseignement des paramètres
        $config = ShopymindClient_Configuration::factory(
            $apiIdentification,
            $apiPassword,
            $defaultLang,
            $defaultCurrency,
            ShopiMindConfiguration::getContactPageURL(),
            ShopiMindConfiguration::getPhoneNumber(),
            $timezone,
            is_multisite(),
            $shop_id_shop,
            $forceSyncProducts,
            $woocommerce_version,
            $ShopiMindClient_Callback->getModuleVersion()
        );

        $config->setUrlClient( trailingslashit(  trailingslashit( SHOPIMIND_URL ) . 'api'  ) );

        $output = '';
        try {
            // Sauvegarde du fichier de configuration
            if ( !$config->testConnection() ) {
                throw new Exception(
                    __( 'Erreur lors du test de connection au serveur', 'shopimind' )
                    . '<br /><b>'
                    . __( 'Veuillez vérifier que votre site n’est pas en mode maintenance ou protégé par un htaccess.', 'shopimind' )
                    . '</b>'
                );
            }
            else {
                // Connexion au serveur et sauvegarde des informations
                $connect = $config->connectServer();


                if ($connect !== true) {
                    echo " 3";
                    throw new Exception(
                        __( 'Erreur lors de la connection au serveur', 'shopimind' )
                        . '<br /><b>'
                        . __( 'Veuillez vérifier que votre site n’est pas en mode maintenance ou protégé par un htaccess.', 'shopimind' )
                        . '</b>'
                    );
                } else {
                    if ( $new_activation ) {
                        $output .=
                            '<div class="notice notice-success">'
                            . __( 'Activation réussie !', 'shopimind' )
                            . '<br />'
                            . __( 'Nous venons de vous envoyer un email afin de finaliser votre inscription. Ouvrez-le et laissez vous guider.', 'shopimind' )
                            . '</div>';
                    }
                    else {
                        $output .=
                            '<div class="notice notice-success">'
                            . __( 'Configuration sauvegardée', 'shopimind' )
                            .'</div>';
                    }
                }
            }
        } catch (Exception $e) {
            $output .= '<div class="notice notice-warning">' . $e->getMessage() . '</div>';
        }

        return $output;
    }
