<?php
// Load WordPress
define( 'DOING_AJAX', true );

$allowed_ips = array('​88.165.142.51', getHostByName(getHostName()), '203.150.171.174' );
/*if( !in_array($_SERVER['REMOTE_ADDR'], $allowed_ips ))  {
	return;
}*/


$parse_uri = explode( 'wp-content', $_SERVER['SCRIPT_FILENAME'] );
$wp_load_dir = $parse_uri[0] . 'wp-load.php';

if (!file_exists($wp_load_dir)) {
    if (file_exists(dirname(__FILE__).'/../vars.php')) {
        require_once(dirname(__FILE__).'/../vars.php');
    } else {
        $wpLoadPath = dirname(__FILE__) . '/..';
        $wpLoadPathFile = $wpLoadPath . '/wpLoadPath.php';
        if (file_exists($wpLoadPathFile)) {
            require_once($wpLoadPathFile);
        }
        if (!file_exists($wp_load_dir)) {
            function get_wp_abspath($filename)
            {
                $_DIR = __DIR__;
                $_FILE = $_DIR . '/' . $filename;

                while (!file_exists($_FILE)) {
                    $_DIR = dirname($_DIR);
                    $_FILE = $_DIR . '/' . $filename;
                    if ($_DIR == '/') return FALSE;
                }

                return $_FILE;
            }

            $wp_load_dir = get_wp_abspath('wp-load.php');
            if (file_exists($wp_load_dir) && is_writable($wpLoadPath)) {
                file_put_contents($wpLoadPathFile, '<?php $wp_load_dir = "' . $wp_load_dir . '";?>');
            }
        }
    }
}
require_once($wp_load_dir);

// log request
$array = array(
	'GET'		=> $_GET,
	'POST'		=> $_POST,
	'REDIRECT_SCRIPT_URI'	=> isset($_SERVER['REDIRECT_SCRIPT_URI']) ? $_SERVER['REDIRECT_SCRIPT_URI']:'',
	'php_version'	=> phpversion(),
	'headers'	=> function_exists( 'getallheaders') ? getallheaders() : 'headers',
	'input'		=> file_get_contents('php://input')
);

// Load API Server class
require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/apiserver.class.php' );
require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/error.class.php' );
require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/callback.php' );

if (file_exists(trailingslashit( SHOPIMIND_PATH ) . 'api/callback_override.php')){
    require_once( trailingslashit( SHOPIMIND_PATH ) . 'api/callback_override.php' );
}

require_once( trailingslashit( SHOPIMIND_PATH ) . 'ShopyMindClient/src/Server.php' );
$ShopymindClient_Server = new ShopymindClient_Server();

if(class_exists('ShopiMind\ShopiMindClient_CallbackOverride')) {
	$ShopiMindClient_Callback = new ShopiMind\ShopiMindClient_CallbackOverride( $_REQUEST );
}
else {
	$ShopiMindClient_Callback = new ShopiMind\ShopiMindClient_Callback( $_REQUEST );
}

// installed and set up
$plugin_configured = $ShopiMindClient_Callback->selfCheck();
if( ShopiMind\is_api_error( $plugin_configured ) ) {
	$error = $plugin_configured->get_error_message();
	$ShopymindClient_Server->sendResponse( compact( 'error' ), false );
	//$ShopiMindClient_Callback->sendError( $plugin_configured->get_error_message() );
}


// valid request
$is_valid = $ShopymindClient_Server->isValid();
//$is_valid = true;

if( !$is_valid ) {
	$error = __('Requête invalide', 'shopimind' );
	$errors  = $ShopymindClient_Server->debug;

	$ShopymindClient_Server->sendResponse( compact( 'error','errors' ), false );
}

$request_method = $ShopymindClient_Server->getTypeRequest();
if( empty( $request_method ) ) {
	$request_method = 'sayHello';
}

$method = $ShopiMindClient_Callback->setMethod( $request_method );
if( ShopiMind\is_api_error( $method ) ) {
	$error = $method->get_error_message();
	$ShopymindClient_Server->sendResponse( compact( 'error' ), false );
	//$ShopiMindClient_Callback->sendError( $method->get_error_message() );
}


// parse request
$parse = $ShopiMindClient_Callback->parseRequest();
if( ShopiMind\is_api_error( $parse ) ) {
	$error = $parse->get_error_message();
	$ShopymindClient_Server->sendResponse( compact( 'error' ), false );
	//$ShopiMindClient_Callback->sendError( $parse->get_error_message() );
}
// valid request
$can_execute = $ShopiMindClient_Callback->canExecute();
if( ShopiMind\is_api_error( $can_execute ) ) {
	$error = $can_execute->get_error_message();
	$ShopymindClient_Server->sendResponse( compact( 'error' ), false );
	$ShopiMindClient_Callback->sendError( $can_execute->get_error_message() );
}

// execute
$return = $ShopiMindClient_Callback->execute();
if( ShopiMind\is_api_error( $return ) ) {
	$error = $return->get_error_message();
	$ShopymindClient_Server->sendResponse( compact( 'error' ), false );
	//$ShopiMindClient_Callback->sendError( $return->get_error_message() );
}

// Return JSON
$ShopymindClient_Server->sendResponse( $return, true );
//$ShopiMindClient_Callback->sendSuccess( $return );

