<?php
namespace ShopiMind;

function generateCouponCode($voucherInfos) {
	$coupon_code_bits = array( 'SPM' );
	if( isset( $voucherInfos['dynamicPrefix'] ) && strlen( trim( $voucherInfos['dynamicPrefix'] )) ) {
		$coupon_code_bits[] = trim( $voucherInfos['dynamicPrefix'] );
	}

	$prefixes = $coupon_code_bits;

	$uniq_code = strtoupper( substr( str_shuffle( str_repeat( "0123456789abcdefghijklmnopqrstuvwxyz", 5 )), 0, 5 ));
	$coupon_code_bits[] = $uniq_code;
	$coupon_code = implode( '-', $coupon_code_bits );
	while( !$coupon_code || get_page_by_title( $coupon_code, OBJECT, 'shop_coupon' ) ) {
		$coupon_code_bits = $prefixes;
		$uniq_code = strtoupper( substr( str_shuffle( str_repeat( "0123456789abcdefghijklmnopqrstuvwxyz", 5 )), 0, 5 ));
		$coupon_code_bits[] = $uniq_code;
		$coupon_code = implode( '-', $coupon_code_bits );
	}

	return $coupon_code;
}

function getAdminUserID() {
	$admins = \get_super_admins();
	$admin_slug = $admins[0];
	$WP_User = \get_user_by( 'slug', $admin_slug );
	if($WP_User) {
		return $WP_User->get_id();		
	}
	else {
		return 1;
	}
}

function getOrderProducts( $items ) {
	$products = array();
	if( is_array($items) && count($items) > 0 )  {
        $default_lang = function_exists('pll_default_language') ? pll_default_language() : null;
        foreach( $items as $WC_Order_Item_Product ) {
            $product = array();

            if ($WC_Order_Item_Product->get_product_id() > 0) {
                $product_id = $WC_Order_Item_Product->get_product_id();
                // 🔁 Adaptation Polylang
                if ($default_lang && function_exists('pll_get_post')) {
                    $translated_product_id = pll_get_post($product_id, $default_lang);
                    if ($translated_product_id) {
                        $product_id = $translated_product_id;
                    }
                }
                $product['id_product'] 		= $product_id;
                $product['id_combination'] 	= $WC_Order_Item_Product->get_variation_id();
                $product['id_manufacturer'] = '1';
                $product['qty']				= $WC_Order_Item_Product->get_quantity();
                $product['price']			= floatval($WC_Order_Item_Product->get_total());
                $product['price_without_tax'] = floatval($WC_Order_Item_Product->get_total() - $WC_Order_Item_Product->get_total_tax());
                $product['id_categories'] 	= $WC_Order_Item_Product->get_product()->get_category_ids();

                $products[] = $product;
            }

        }
    }
	return $products;
}

/**
 * Renvoie les adresses avec id par client
*/
function getAddress( $address ) {
	$address_identifier = array();

	$translation = array(
		'first_name'	=> 'first_name',
	 	'last_name'	=> 'last_name',
	 	'phone'	=> 'phone1',
	 	//'phone2'	=> 'phone2',
	 	'company'	=> 'company',
	 	'address_1'	=> 'address1',
	 	'address_2'	=> 'address2',
	 	'postcode'	=> 'postcode',
	 	'city'		=> 'city',
	 	'country'	=> 'other',
	 	//'active'	=> 1,
 	);
 	$address_data = array();

	foreach( $translation as $wp_key => $spm_key ) {
		if( isset( $address[$wp_key] )) {
			$address_data[$spm_key] = $address[$wp_key];
		}
		else {
			$address_data[$spm_key] = '';
		}
	}
	$identifier = md5( implode( ':', $address_data ));

	global $wpdb;
	$table = \ShopiMindConfiguration::getSPMAdressesTableName();
	$sql = "SELECT id as id_address, first_name, last_name, phone1, phone2, company, address1, address2, postcode, city, other FROM $table WHERE identifier = %s";
	$sql = $wpdb->prepare( $sql, $identifier );
	$shopimind_address = $wpdb->get_row( $sql, ARRAY_A );

	//$shopimind_address['identifier'] = $identifier;
	//print_r($shopimind_address, " POUR ID $identifier");


	if( !$shopimind_address ) {
		$address_data['identifier'] = $identifier;
		$address_data['phone2'] = '';
		$return = $wpdb->insert( $table, $address_data );
		if( \is_wp_error( $return )) {
			throw new Exception( "Error on new adress '$identifier'", 1 );
		}

		$id_address = $wpdb->insert_id;
		$shopimind_address = $address_data;
		$shopimind_address['id_address'] = $id_address;
		unset( $shopimind_address['identifier'] );
	}

	$shopimind_address['active']  = 1;
	return $shopimind_address;
}

function getDistinctMetaValuesFor( $meta_key, $with_count = true, $post_stati = array( 'publish' )) {
	global $wpdb;

	$sql = "SELECT DISTINCT( meta_value )";
	$values = array();

	if( $with_count ) $sql .= " COUNT( post_id ) as meta_count";

	$sql .= " FROM $wpdb->postmeta WHERE meta_key = %s";
	$values[] = $meta_key;

	$sql .= " AND post_id IN ( SELECT ID FROM $wpdb->posts WHERE post_type = 'product'";
	if( is_array( $post_stati ) && count( $post_stati )) {
		$placeholder = implode( ', ', array_fill( 0, count( $post_stati ), '%s' ) );
		$sql .= " AND post_status IN ( $placeholder )";
		$values[] = $post_stati;
	}
	$sql .= " )";
	$sql = $wpdb->prepare( $sql, $values );
	$results = $wpdb->get_results( $sql, ARRAY_A );
	$meta_values = array();
	if( $results ) foreach( $results as $result ) {
		if( $with_count ) {
			$meta_values[] = array(
				'name'	=> $result['meta_value'],
				'count'	=> $result['meta_count'],
				);
		}
		else {
			$meta_values[] = array(
				'name'	=> $result['meta_value'],
				);
		}
	}
	return $meta_values;
}

function getDistinctTermsFor( $taxonomy, $with_count = true ) {
	$args = array(
		'taxonomy'	=> $taxonomy,
	);
	if( $with_count ) {
		$args['hide_empty'] = false;
	}
	$terms = \get_terms( $args );

	$return = array();
	if( $terms ) foreach( $terms as $term ) {
		if( $with_count ) {
			$return[] = array(
				'ID'	=> $term->ID,
				'name'	=> $term->name,
				'count'	=> $term->count,
			);
		}
		else {
			$return[] = array(
				'ID'	=> $term->ID,
				'name'	=> $term->name,
			);
		}
	}
	return $return;
}

function formatString($value, $key, $options) {
    if (!empty($value)) {
        $options['glued_string'] .= $key.$options['glue'];
        $options['glued_string'] .= $value.$options['glue'];
    }
}

function implode_recursive(array $array, $glue = ';') {
        $glued_string = '';
        // Recursively iterates array and adds key/value to glued string
        array_walk_recursive($array, array( $this, 'formatString' ), array('glue' => $glue, 'glued_string' => &$glued_string));
        // Removes last $glue from string
        strlen($glue) > 0 and $glued_string = substr($glued_string, 0, -strlen($glue));

        // Trim ALL whitespace
        $glued_string = preg_replace("/(\s)/ixsm", '', $glued_string);

        return (string) $glued_string;
    }
